unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Buttons, StdCtrls, Grids, DBGrids, ExtCtrls, DBCtrls, Db, DBTables,
  ComCtrls;

type
  TForm1 = class(TForm)
    ComboBox2: TComboBox;
    Database1: TDatabase;
    DataSource1: TDataSource;
    DBGrid1: TDBGrid;
    Edit2: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Panel1: TPanel;
    Query1: TQuery;
    RadioButton1: TRadioButton;
    RadioButton2: TRadioButton;
    Shape1: TShape;
    Shape2: TShape;
    Shape3: TShape;
    Table1: TTable;
    Query2: TQuery;
    BitBtn2: TBitBtn;
    BitBtn1: TBitBtn;
    DBNavigator1: TDBNavigator;
    ComboBox1: TComboBox;
    Memo1: TMemo;
    BitBtn3: TBitBtn;
    RadioButton3: TRadioButton;
    RichEdit1: TRichEdit;
    procedure RadioButton3Click(Sender: TObject);
    procedure Create(Sender: TObject);
    procedure Memo1KeyPress(Sender: TObject; var Key: Char);
    procedure ComboBox1Change(Sender: TObject);
    procedure DBNavigator1Click(Sender: TObject; Button: TNavigateBtn);
    procedure BitBtn2Click(Sender: TObject);
    procedure DataSource1DataChange(Sender: TObject; Field: TField);
    procedure BitBtn3Click(Sender: TObject);
    procedure ComboBox2Change(Sender: TObject);

  private
    { Private declarations }
  public
    { Public declarations }
end;

Procedure My_Privilege(My_State:integer);
Procedure My_LED(My_State:integer);
Procedure My_Query(My_Sql:String);
Procedure My_Search(Sender:TObject);
Procedure My_RichEdit(Sender:TObject);
Function My_QuoteSQL(My_Src: String):String;

var
   Form1: TForm1;
   My_ReadyToQuery:Boolean;
   My_Connect:Boolean;


implementation

{$R *.DFM}

type
  error = class(Exception);

{ Form1 Created & Initial Setting }
procedure TForm1.Create(Sender: TObject);
begin
   My_Privilege(0);
   My_LED(0);
   My_ReadyToQuery:=False;
   My_Connect:=False;
   Memo1.Text:='';
   ComboBox2.ItemIndex:= 0;
end;

{ Connect / Disconnect database }
procedure TForm1.BitBtn3Click(Sender: TObject);
begin
   if My_Connect=False then
   begin
      My_Privilege(1);
      Database1.DatabaseName:=Database1.AliasName; //+'x';
      My_ReadyToQuery:=False;
      try
         Table1.DatabaseName:=Database1.DatabaseName;
         Query1.DatabaseName:=Database1.DatabaseName;
         database1.Connected:=True;
         //ComboBox1.Items.Clear();
         ComboBox1.Items.Add('sample.books');
         ComboBox1.ItemIndex:=0;
         ComboBox1Change(Sender);
         Form1.Memo1.Enabled:=True;
         Memo1.text:='Connect successful.';
         My_LED(1);
         bitbtn3.Kind:=bkNo;
         bitbtn3.Caption:='&Disconnect';
      except
         on e:exception do
         begin
            Memo1.text:=e.message;
            My_Privilege(0);
         end
      end
   end
   else
   begin
      Form1.ComboBox1.Items.Clear();
      //Form1.ComboBox1.Text :='';
      Form1.ComboBox2.Items.Clear();
      My_Privilege(0);
      bitbtn3.Kind:=bkRetry;
      bitbtn3.Caption:='&Connect';
      My_LED(0);
   end;
   if  bitbtn3.Caption='&Connect' then
      My_Connect:=False
   else
      My_Connect:=True;
end;
{ Selected Table Name }
procedure TForm1.ComboBox1Change(Sender: TObject);
begin
   My_Privilege(2);

   Table1.TableName:=ComboBox1.Text;
   Try
      Table1.Active:=True;
      Table1.Active:=False;
      DataSource1.Enabled:=True;
      Memo1.Text:='Select * from '+ComboBox1.text;
      My_Query(Memo1.Text);
      My_ReadyToQuery:=True;
      My_LED(2);

      ComboBox2.Items.Clear();
      ComboBox2.Items.Add('name');
      ComboBox2.Items.Add('author');
      ComboBox2.Items.Add('subject');
      ComboBox2.Items.Add('introduction');
      ComboBox2.Items.Add('content');
      ComboBox2.ItemIndex := 0;
      ComboBox2Change(Sender);
   except
      on e:exception do
         Memo1.text:=e.message;
   end;
end;

{ No Search }
procedure TForm1.RadioButton3Click(Sender: TObject);
var
   My_sql:String;
begin
   if My_ReadyToQuery=False then exit;
   Edit2.Text:='';
   RichEdit1.Text:='';
   My_sql:=' select * from '+ComboBox1.Text;
   Memo1.Text:= My_sql;
   My_Query(My_sql);
end;


{ Manaul Input SQL instruction }
procedure TForm1.Memo1KeyPress(Sender: TObject; var Key: Char);
begin
   if (Key=#13) and My_ReadyToQuery then
      My_Query(Memo1.Text)
end;
{ Move DBNavigator1 }
procedure TForm1.DBNavigator1Click(Sender: TObject; Button: TNavigateBtn);
begin
end;

{ Set the Privilege in ComboBox }
Procedure My_Privilege(My_State:integer);
begin
   Case My_State of
   0: begin
         Form1.Database1.Connected:=False;
         Form1.ComboBox1.Enabled:=False;
         Form1.ComboBox2.Enabled:=False;
         Form1.Edit2.Enabled:=False;
         Form1.RichEdit1.Text:='';
         Form1.RadioButton1.Enabled:=False;
         Form1.RadioButton2.Enabled:=False;
         Form1.RadioButton3.Enabled:=False;
         My_ReadyToQuery:=False
      end;
   1: begin
         Form1.Database1.Connected:=False;
         Form1.Table1.DatabaseName:='';
         Form1.Query1.DatabaseName:='';
         Form1.DataSource1.Enabled:=False;
         Form1.ComboBox1.Enabled:=True;
         Form1.ComboBox1.Items.Clear;
         Form1.ComboBox2.Enabled:=True;
         Form1.Edit2.Enabled:=False;
         Form1.RadioButton1.Enabled:=False;
         Form1.RadioButton2.Enabled:=False;
         Form1.RadioButton3.Enabled:=False;
         My_ReadyToQuery:=False
      end;
   2: begin
         Form1.DataSource1.Enabled:=False;
         Form1.Edit2.Enabled:=True;
         Form1.RadioButton1.Enabled:=True;
         Form1.RadioButton2.Enabled:=True;
         Form1.RadioButton3.Enabled:=True;
         My_ReadyToQuery:=True
      end;
   end;
end;

{ Set LED Single in each state }
Procedure My_LED(My_State:integer);
begin
   case My_State of
   0: begin
         Form1.Shape1.Brush.Color:=clRed;
         Form1.Shape2.Brush.Color:=clRed;
         Form1.Shape3.Brush.Color:=clRed
      end;
   1: begin
         Form1.Shape1.Brush.Color:=clLime;
         Form1.Shape2.Brush.Color:=clRed;
         Form1.Shape3.Brush.Color:=clRed
      end;
   2: begin
         Form1.Shape2.Brush.Color:=clLime;
         Form1.Shape3.Brush.Color:=clRed
      end;
   3: Form1.Shape3.Brush.Color:=clRed;
   4: Form1.Shape3.Brush.Color:=clLime
   end;
end;

{ Execute Query action and Output to DBGrid & DBRichEdit }
Procedure My_Query(My_Sql:String);
begin
   With Form1 do
   begin
      Try
         Query1.Close;
         Query1.SQL.Clear;
         Query1.SQL.Add(My_Sql);
         Query1.ExecSQL;
         Query1.Active:=True;
      except
      on e:exception do
         Memo1.text:=e.message;
      end;
   end;
end;

{ Test if We have enough conditions to Search }
Procedure My_Search(Sender:TObject);
var
   My_Sql:String;
begin
   if Form1.Edit2.Text='' then exit;
   if Form1.RadioButton3.Checked=True then exit;
   My_LED(4);
   With Form1 do
   begin
      if Form1.RadioButton1.Checked=True then
         My_Sql:=' Select * from '+ComboBox1.Text+
         ' where '+ComboBox2.Text+' contain '''+My_QuoteSQL(Edit2.Text)+'''';
      if Form1.RadioButton2.Checked=True then
         My_Sql:=' Select * from '+ComboBox1.Text+
         ' where '+ComboBox2.Text+' match '''+My_QuoteSQL(Edit2.Text)+'''';
      My_Query(My_Sql);
      My_RichEdit(Sender);
      Memo1.Text:=My_Sql;
   end;
end;

{ Clear ' from string in Edit2 }
Function My_QuoteSQL(My_Src: String):String;
Var J:Integer;
    Buf, Desc:String;
begin
  Desc:= My_Src;
  J:= Pos('''',Desc);
  while (J > 0) do
  begin
    Buf:= Buf + Copy(Desc,1,J)+'''';
    Desc:= Copy(Desc,J+1,length(Desc));
    J:= Pos('''',Desc);
  End;
  If length(Desc) > 0 Then
    Buf:= Buf + Desc;
  Result:= Buf;
end;


{ RichEdit for Search String with
  DBMaster3.5 New Instruction : 'HitCount' & 'HitPos' }
Procedure My_RichEdit(Sender:TObject);
var
   My_Sql,String1,String2,String3:String;
   My_Pos,My_Times:Integer;
   i:Integer;

begin
   with Form1 do
   begin
      if RichEdit1.Text='' then exit;
      if Edit2.Text='' then exit;
      RichEdit1.SelStart:=0;
      RichEdit1.SelLength:=Length(RichEdit1.Text);
      RichEdit1.SelAttributes.Color:=clBlack;
        RichEdit1.SelLength:=0;
      String1:='hitcount('+ComboBox2.Text + ',''' + Edit2.Text +''',0)';
      My_Sql:='Select ' + String1 + ' as hit_count from '+ComboBox1.Text
               + ' where id = ' + Query1.Fields[0].AsString;

      Try
         Query2.DatabaseName:=Database1.DatabaseName;
         Query2.SQL.Clear;
         Query2.SQL.Add(My_Sql);
         Query2.Active:=True;
         My_Times:= Query2.FieldByName('hit_count').AsInteger;         // hitcount
         Query2.Active:=False;
         if My_Times < 1 then exit;

         String3:='hitpos(' + ComboBox2.Text + ',''' + Edit2.Text + ''',0,';
         for i:=1 to My_Times do
         begin
            String2:= String3 + IntToStr(i) +',3)';
            My_Sql:='Select ' + String2 + ' from ' + ComboBox1.Text
                    + ' where id = ' + Query1.Fields[0].AsString;

            Query2.SQL.Clear;
            Query2.SQL.Add(My_sql);
            Query2.Active:=True;
            My_Pos:=Query2.Fields[0].AsInteger;      // hitpos
            Query2.Active:=False;

            RichEdit1.SelStart:=My_Pos shr 8 -1;
            RichEdit1.SelLength:=My_Pos - (My_Pos shr 8) shl 8;
            RichEdit1.SelAttributes.Color:=clRed;
         end
      except
         on e:exception do
            Memo1.text:=e.message;
      end;
      RichEdit1.SelLength:=0;
      RichEdit1.SelAttributes.Color:=clBlack;
   end;
end;


procedure TForm1.BitBtn2Click(Sender: TObject);
begin
  if (Form1.ComboBox1.Text='') or (Form1.ComboBox2.Text = '') or (Form1.Edit2.Text = '') then exit;

   Memo1.Text:='';
   if My_ReadyToQuery = True then
      My_Search(Sender);
end;

procedure TForm1.DataSource1DataChange(Sender: TObject; Field: TField);
begin
   RichEdit1.Text:= Query1.Fields[ComboBox2.ItemIndex+1].AsString;
   My_RichEdit(Sender);
end;

procedure TForm1.ComboBox2Change(Sender: TObject);
begin
   RichEdit1.Text:= Query1.Fields[ComboBox2.ItemIndex+1].AsString;
end;

end.




