using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using System.Data.OleDb;

namespace asp_net_sample
{

	public class basicOperation : System.Web.UI.Page
	{
		protected System.Web.UI.WebControls.TextBox txtDBName;
		protected System.Web.UI.WebControls.Button btnConnect;
		protected System.Web.UI.WebControls.Panel pnl1;
		protected System.Web.UI.WebControls.Panel pnl2;
		protected System.Web.UI.WebControls.Label lblCreate;
		protected System.Web.UI.WebControls.Button btnCreate;
		protected System.Web.UI.WebControls.Panel pnl3;
		protected System.Web.UI.WebControls.Label lblInsert;
		protected System.Web.UI.WebControls.Table tblInsert;
		protected System.Web.UI.WebControls.Button btnInsert;
		protected System.Web.UI.WebControls.Panel pnl4;
		protected System.Web.UI.WebControls.Label lblRecord1;
		protected System.Web.UI.WebControls.DataGrid DataGrid1;
		protected System.Web.UI.WebControls.Button btnUpdate;
		protected System.Web.UI.WebControls.Label lblRecord2;
		protected System.Web.UI.WebControls.DataGrid DataGrid2;
		protected System.Web.UI.WebControls.Label lblDelete;
		protected System.Web.UI.WebControls.Button btnDelete;
		protected System.Web.UI.WebControls.Label lblRecord3;
		protected System.Web.UI.WebControls.DataGrid DataGrid3;
		protected System.Web.UI.WebControls.Label lblDrop;
		protected System.Web.UI.WebControls.Button btnDrop;
		protected System.Web.UI.WebControls.Panel pnl5;
		protected System.Web.UI.WebControls.Panel pnl6;
		protected System.Web.UI.WebControls.TextBox txtUser;
		protected System.Web.UI.WebControls.TextBox txtPwd;
		protected System.Web.UI.WebControls.Label lblError;
		protected System.Web.UI.WebControls.Label lblUpdate;
		protected System.Web.UI.WebControls.Label lblInfo;
		protected System.Web.UI.WebControls.Label lblCaption;
	
		private void Page_Load(object sender, System.EventArgs e)
		{
			if(!this.IsPostBack)
			{
				displayPanel(1);	//display connect panel
			}
		}

		#region Web ɵĴ
		override protected void OnInit(EventArgs e)
		{
			InitializeComponent();
			base.OnInit(e);
		}
		
		private void InitializeComponent()
		{    
			this.btnConnect.Click += new System.EventHandler(this.btnConnect_Click);
			this.btnCreate.Click += new System.EventHandler(this.btnCreate_Click);
			this.btnInsert.Click += new System.EventHandler(this.btnInsert_Click);
			this.btnUpdate.Click += new System.EventHandler(this.btnUpdate_Click);
			this.btnDelete.Click += new System.EventHandler(this.btnDelete_Click);
			this.btnDrop.Click += new System.EventHandler(this.btnDrop_Click);
			this.Load += new System.EventHandler(this.Page_Load);

		}
		#endregion

		private void btnConnect_Click(object sender, System.EventArgs e)
		{
			string oledbProvider = System.Configuration.ConfigurationSettings.AppSettings["OleDbProvider"];
			string myCNString = "Provider=" + oledbProvider ;
			myCNString += "; Data Source=" + txtDBName.Text.Trim();
			myCNString += "; User Id=" + txtUser.Text.Trim();
			myCNString += "; Password=" + txtPwd.Text + ";";
			OleDbConnection myCN = new OleDbConnection(myCNString);
			try
			{
				myCN.Open();
				this.ViewState["ConnectionString"] = myCNString;
				displayPanel(2);	// display create table panel
				this.Response.Write(getScript("Connect successfully!"));
			}
			catch(Exception ex)
			{
				lblError.Text = ex.Message + "<br>Connection String is:" + myCNString;
				displayPanel(1);
			}
			finally
			{
				if(myCN != null) myCN.Close();
			}
		}

		private void btnCreate_Click(object sender, System.EventArgs e)
		{
			string myCNString = (string)this.ViewState["ConnectionString"];
			string myCMString = "create table aspx_emp(id integer primary key";
			myCMString += ",name varchar(30),eLevel integer,salary double)";
			OleDbConnection myCN = new OleDbConnection(myCNString);
			OleDbCommand myCM = new OleDbCommand("",myCN);

			try
			{
				myCN.Open();
				try
				{
					myCM.CommandText = "drop table aspx_emp";
					myCM.ExecuteNonQuery();
				}
				catch(Exception ex){}
				finally
				{
					myCM.CommandText = myCMString;
				}
				myCM.ExecuteNonQuery();
				displayPanel(3);	// display insert data panel
				this.Response.Write(getScript("Create table successfully!"));
			}
			catch(Exception ex)
			{
				lblError.Text = ex.Message + "<br>" + myCMString;
				displayPanel(2);
			}
			finally
			{
				if(myCN != null) myCN.Close();
			}
		}

		private void btnInsert_Click(object sender, System.EventArgs e)
		{
			string myCNString = (string)this.ViewState["ConnectionString"];
			string myCMString ;
			OleDbConnection myCN = new OleDbConnection(myCNString);
			OleDbCommand myCM = new OleDbCommand("",myCN);
			
			try
			{
				myCN.Open();
				for(int i=1; i<5; i++)
				{
					int id = Int32.Parse(tblInsert.Rows[i].Cells[0].Text);
					string name = tblInsert.Rows[i].Cells[1].Text;
					int elevel = Int32.Parse(tblInsert.Rows[i].Cells[2].Text);
					double salary = Double.Parse(tblInsert.Rows[i].Cells[3].Text);

					myCMString = "insert into aspx_emp values";
					myCMString += "(" + id.ToString() + ",'" + name + "'," + elevel.ToString();
					myCMString += "," + salary.ToString() + ")";
					myCM.CommandText = myCMString;
					myCM.ExecuteNonQuery();
				}
				displayPanel(4);	// display update data panel
				this.Response.Write(getScript("Insert successfully!"));
			}
			catch(Exception ex)
			{
				lblError.Text = ex.Message + "<br>" + myCM.CommandText;
				displayPanel(3);
			}
			finally
			{
				if(myCN != null) myCN.Close();
			}
		}

		private void btnUpdate_Click(object sender, System.EventArgs e)
		{
			string myCNString = (string)this.ViewState["ConnectionString"];
			string myCMString = lblUpdate.Text;
			OleDbConnection myCN = new OleDbConnection(myCNString);
			OleDbCommand myCM = new OleDbCommand(myCMString,myCN);
			try
			{
				myCN.Open();
				myCM.ExecuteNonQuery();
				displayPanel(5);	// display delete data panel
				this.Response.Write(getScript("Update successfully!"));
			}
			catch(Exception ex)
			{
				lblError.Text = ex.Message + "<br>" + myCM.CommandText;
				displayPanel(4);
			}
			finally
			{
				if(myCN != null) myCN.Close();
			}
		}

		private void btnDelete_Click(object sender, System.EventArgs e)
		{
			string myCNString = (string)this.ViewState["ConnectionString"];
			string myCMString = lblDelete.Text;
			OleDbConnection myCN = new OleDbConnection(myCNString);
			OleDbCommand myCM = new OleDbCommand(myCMString,myCN);
			try
			{
				myCN.Open();
				myCM.ExecuteNonQuery();
				displayPanel(6);	// display drop table panel
				this.Response.Write(getScript("Delete successfully!"));
			}
			catch(Exception ex)
			{
				lblError.Text = ex.Message + "<br>" + myCM.CommandText;
				displayPanel(5);
			}
			finally
			{
				if(myCN != null) myCN.Close();
			}
		}

		private void btnDrop_Click(object sender, System.EventArgs e)
		{
			string myCNString = (string)this.ViewState["ConnectionString"];
			string myCMString = lblDrop.Text;
			OleDbConnection myCN = new OleDbConnection(myCNString);
			OleDbCommand myCM = new OleDbCommand(myCMString,myCN);
			try
			{
				myCN.Open();
				myCM.ExecuteNonQuery();
				displayPanel(0);
				this.Response.Write(getScript("Drop table successfully!"));
				this.Response.Write(getScript("Good bye!"));
				this.Response.Write("<script language=javascript>window.close()</script>");
			}
			catch(Exception ex)
			{
				lblError.Text = ex.Message + "<br>" + myCM.CommandText;
				displayPanel(6);
			}
			finally
			{
				if(myCN != null) myCN.Close();
			}
		}

		private void displayPanel(int visiblePanel)
		{
			for(int i=1;i<=6;++i)
			{
				if(i != visiblePanel)
				{
					((Panel)this.FindControl("pnl" + i.ToString())).Visible = false;
				}
				else
				{
					((Panel)this.FindControl("pnl" + i.ToString())).Visible = true;
				}
			}

			if((visiblePanel == 4) || (visiblePanel == 5) || (visiblePanel == 6))
			{
				OleDbConnection myCN = new OleDbConnection();
				myCN.ConnectionString = (string)this.ViewState["ConnectionString"];
				if(myCN.ConnectionString == "") return;
				OleDbCommand myCM = new OleDbCommand("select * from aspx_emp",myCN);
				DataSet myDS = new DataSet();
				OleDbDataAdapter myDA = new OleDbDataAdapter(myCM);
				try
				{
					myCN.Open();
					myDA.Fill(myDS,"aspx_emp");

					DataGrid1.DataSource = myDS;
					DataGrid1.DataMember = "aspx_emp";
					DataGrid1.DataBind();

					DataGrid2.DataSource = myDS.Tables["aspx_emp"];
					DataGrid2.DataBind();

					DataGrid3.DataSource = myDS.Tables["aspx_emp"];
					DataGrid3.DataBind();

				}
				catch(Exception ex)
				{
					lblError.Text = ex.Message;
				}
				finally
				{
					if(myCN != null) myCN.Close();
				}
			}
		}

		private string getScript(string msg)
		{
			string scriptString = "<script language=javascript>";
			scriptString += "alert('" + msg + "');";
			scriptString += "</script>";
			return scriptString;
		}
	}
}
